UIManager = class()

function UIManager:created()
    -- you can accept and set parameters here
    
    self.manager = scene.main:findEntity("Manager"):get(GameManager)
    text.style.dance = function(tag, format)
        local height = tag:number("height", 2) 
        format.callback = function(str, i, mod)
            local pi = math.pi
            if i % 2 == 0 then
                pi = 0
            end
            mod.offsetY = mod.offsetY + math.sin(time.elapsed*5 + pi) * height
        end
    end
    
    text.style.appear = function(tag, format)
        local t = (time.elapsed  - self.manager.startTime) * tag:number("speed", 5)
        f = format.fillColor.a     
        
        format.callback = function(str, i, mod)
            local a = math.min(math.max(t - i, 0.0), 1.0)
            mod.alpha = a * f
        end
    end
    
    text.style.stroke = function(tag, format)
        local width = tag:number("width", 2) 
        format.strokeWidth = width /scene.main.canvas.scale
    end
    
    text.style.moveDown = function(tag, format)
        local d = tag:number("down", 5)
        local t  = format.fontSize
        
        format.callback = function(str, i, mod)
            mod.offsetY = d * t
        end
    end
    
    text.style.setFont = function(tag, format)
        format.fontSize = format.fontSize / tag:number("font", 5)
    end
    
    text.style.stroke = function(tag, format)
        local width = tag:number("width", 2) 
        format.strokeWidth = width /scene.main.canvas.scale
    end
    
    text.style.strokePulse = function(tag, format)
        local speed = tag:number("speed", 2) 
        local size = tag:number("size", 2)
        format.strokeColor = color(0)
        format.strokeWidth = ((math.cos(time.elapsed * speed) * ((size +3)/2.)) + (size+3)) /scene.main.canvas.scale
    end
    
    
    self.titleText = scene.main.canvas:child("TitleText")
    self.titleText.size = vec2(1400, 200)
    self.titleText:anchor(CENTER, TOP)
    local label = self.titleText:add(ui.label)
    label.text = "<appear speed = '5'><dance height = '5'><stroke width = '20'><i>Flappy Bird</i></stroke></dance></appear>"
    -- label.font = "ArialRoundedMTBold"
    label.shadow = color(233, 77, 77, 0)
    label.fontSize = 130
    label.color = color(245, 46, 27)
    
    label.style = TEXT_RICH
    self.titleText.y = -200
    
    self.tap = scene.main.canvas:child("Tap")
    
    self.tap.size = vec2(1400, 200)
    label = self.tap:add(ui.label)
    label.text = "<strokePulse size = '5' speed = '5'>Tap To Start</strokePulse>"
    label.font = "ArialRoundedMTBold"
    label.shadow = color(233, 77, 77, 0)
    label.fontSize = 65
    label.color = color(255)
    
    label.style = TEXT_RICH
    self.tap.y = -220
    
    self.scoreText = scene.main.canvas:child("TitleText")
    self.scoreText.size = vec2(150, 80)
    
    self.scoreFillColor = color(218, 178, 217, 0)
    self.scoreStrokeColor = color(197, 143, 200, 0)
    
    self.scoreText.draw = function()
        style.push().fill(self.scoreFillColor).stroke(self.scoreStrokeColor).strokeWidth(14)
        rect(0,0,self.scoreText.size.x, self.scoreText.size.y, 50)
        style.pop()
    end
    self.scoreText:anchor(LEFT, TOP)
    self.scoreText.pivot = vec2(0, 1)
    
    self.labelEntity = self.scoreText:child("score")
    self.labelEntity.size = vec2(150, 80)
    self.labelEntity:anchor(CENTER, TOP)
    self.labelEntity.pivot = vec2(0.5, 1)
    label = self.labelEntity:add(ui.label)
    
    -- label.font = "ArialRoundedMTBold"
    label.shadow = color(233, 77, 77, 0)
    label.fontSize = 60
    label.color = color(255, 0)
    label.align = CENTER|MIDDLE
    self.scoreLabel = label
    
    
    label.style = TEXT_RICH
    self.scoreText.position = vec3(40,-50,0)
    
    self.overPosition = vec2(48, -60)
    
    
    self.gameOver = self.scoreText:child("Game Over Text")
    self.gameOver.size = vec2(WIDTH - math.abs(self.overPosition.x) * 2.0,HEIGHT - math.abs(self.overPosition.y) * 2.0)
    self.gameOver:anchor(CENTER, TOP)
    self.gameOver.pivot = vec2(0.5, 1)
    self.gameOver.y = -20
    
    label = self.gameOver:add(ui.label)
    label.font = "ArialRoundedMTBold"
    label.shadow = color(233, 77, 77, 0)
    label.fontSize = 30
    label.color = color(255, 0)
    label.align = CENTER|TOP
    
    label.style = TEXT_RICH
    self.gameOverLabel = label
    
    self.restart = self.scoreText:child("Restart")
    self.restart.size = vec2(WIDTH - math.abs(self.overPosition.x) * 3.0, 300)
    self.restart:anchor(CENTER, BOTTOM)
    self.restart.pivot = vec2(0.5, 0)
    self.restart.y = 70
    
    self.restartButton = self.restart:add(ui.button)
    
    self.restart.color = color(220, 109, 105,0)
    self.restartButton.style.normal.color = color(220, 109, 105,0)
    self.restartButton.style.pressed.color = color(209, 79, 72,0)
    
    self.restartButton.label.font = "ArialRoundedMTBold"
    self.restartButton.label.shadow = color(233, 77, 77, 0)
    self.restartButton.label.fontSize = 150
    self.restartButton.label.text = "RESTART"
    self.restartButton.label.color = color(255, 0)    
    
    
    self.restart.tapped = function()
        if not self.manager.currentRestarting then
            self.manager.startRestart = true
            local instance = sound.play(asset.sfx_swooshing)
            table.insert(allSounds, instance)
        end
    end
end

function UIManager:update()
    if self.manager.isRestarting then
        
        tween(self.scoreText):to{size = vec2((WIDTH * scene.main.canvas.scale) - math.abs(self.overPosition.x) * 2,(HEIGHT * scene.main.canvas.scale) - math.abs(self.overPosition.y) * 2), position = vec3(self.overPosition.x, self.overPosition.y, 0)}:time(0.17):to{size = vec2(150, 80), position = vec3(40,-50,0)}:time(0.33):ease(tween.quinticOut):onComplete(function() 
            self.titleText:get(ui.label).color.a = 255 
        end)
        tween(self.scoreFillColor):to{a = 0}:time(0.45)
        tween(self.scoreStrokeColor):to{a = 0}:time(0.45)
        tween(self.scoreLabel.color):to{a = 0}:time(0.45)
        
        tween(self.tap:get(ui.label).color):to{a = 0}:time(0.5):to{a = 255}:time(0.25)
        
        tween(self.gameOverLabel.color):to{a = 0}:time(0.25):ease(tween.quinticOut)
        tween(self.gameOverLabel):to{fontSize = 30}:time(0.25):ease(tween.quinticOut)
        tween(self.gameOver):to{y = -20}:time(0.25):ease(tween.quinticOut)
        
        --tween(self.restart):to{size = vec2((WIDTH * scene.main.canvas.scale) - math.abs(self.overPosition.x) * 3.0, 300)}:time(0.25):to{size = }:time(0.25):ease(tween.quinticOut)
        tween(self.restartButton.label):to{color = color(255,0)}:time(0.25)
        tween(self.restart):to{color = color(220, 109, 105,0)}:time(0.25)
        tween(self.restartButton.style.normal):to{color = color(220, 109, 105,0)}:time(0.25)
        tween(self.restartButton.style.pressed):to{color = color(220, 109, 105,0)}:time(0.25)
        
        self.manager.currentRestarting = true;
        self.manager.isRestarting = false
    end
    
    if self.manager.startRestart then
        self.manager.isRestarting = true
        self.manager.startRestart = false
    end
    
    if not  self.manager.justStarted and  self.manager.startGame then
        tween(self.titleText:get(ui.label).color):to{a = 0}:time(0.5)
        tween(self.tap:get(ui.label).color):to{a = 0}:time(0.25)
        tween(self.scoreFillColor):to{a = 0}:time(0.25):to{a = 255}:time(0.5)
        tween(self.scoreStrokeColor):to{a = 0}:time(0.25):to{a = 255}:time(0.5)
        tween(self.scoreLabel.color):to{a = 0}:time(0.25):to{a = 255}:time(0.5)
        self.manager.justStarted = true
    end
    self.scoreLabel.text = string.format("<stroke width = '5'>%d</stroke>", self.manager.score)
    if not  self.manager.justTouchedGround and  self.manager.touchGround then
        tween(self.scoreText):to{size = vec2((WIDTH * scene.main.canvas.scale) - math.abs(self.overPosition.x) * 2,(HEIGHT * scene.main.canvas.scale) - math.abs(self.overPosition.y) * 2), position = vec3(self.overPosition.x, self.overPosition.y, 0)}:time(0.33):ease(tween.quinticOut):onComplete(function() self.manager.finishRestartAnimation = true end)
        tween(self.scoreLabel.color):to{a = 0}:time(0.25):ease(tween.quinticOut)
        self.gameOverLabel.text = string.format("<stroke width = '5'>Game Over\n<moveDown down = '0.5'><setFont font = '2'>Score: %d</setFont></moveDown></stroke>", self.manager.score)
        tween(self.gameOverLabel.color):to{a = 0}:time(0.25):to{a = 255}:time(0.25):ease(tween.quinticOut)
        tween(self.gameOverLabel):to{fontSize = 30}:time(0.25):to{fontSize = 150}:time(0.25):ease(tween.quinticOut)
        tween(self.gameOver):to{y = -20}:time(0.25):to{y = -80}:time(0.25):ease(tween.quinticOut)
        
        
        tween(self.restart):to{size = vec2((WIDTH * scene.main.canvas.scale) - math.abs(self.overPosition.x) * 3.0, 300)}:time(0.25):to{size = vec2((WIDTH * scene.main.canvas.scale) - math.abs(self.overPosition.x) * 3.0, 300)}:time(0.25):ease(tween.quinticOut)
        tween(self.restartButton.label):to{color = color(255,0)}:time(0.25):to{color = color(255)}:time(0.25)
        tween(self.restartButton.style.normal):to{color = color(220, 109, 105,0)}:time(0.25):to{color = color(220, 109, 105)}:time(0.25)
        tween(self.restartButton.style.pressed):to{color = color(220, 109, 105,0)}:time(0.25):to{color = color(209, 79, 72)}:time(0.25)
        tween(self.restart):to{color = color(220, 109, 105,0)}:time(0.25):to{color = color(220, 109, 105)}:time(0.25)
        
        self.manager.justTouchedGround = true
    end
    
    if self.manager.justTouchedGround and  self.manager.touchGround and not self.manager.currentRestarting then
        self.gameOverLabel.size = vec2((WIDTH * scene.main.canvas.scale) - math.abs(self.overPosition.x) ,(HEIGHT * scene.main.canvas.scale) - math.abs(self.overPosition.y) )
        if self.manager.finishRestartAnimation then
            self.scoreText.size = vec2((WIDTH * scene.main.canvas.scale) - math.abs(self.overPosition.x) * 2,(HEIGHT * scene.main.canvas.scale) - math.abs(self.overPosition.y) * 2)
            self.restart.size = vec2((WIDTH * scene.main.canvas.scale) - math.abs(self.overPosition.x) * 3.0, 300)
        end
    end
    
end

function UIManager:touched(touch)
    -- Codea does not automatically call this method
end
